using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

	/* Hierarchische Listenstrukturen am Beispiel (simulierter) Dateien und Ordner.
		SingleEntry = einzelne Datei, Basisklasse
		ListEntry = Verzeichnis, fhrt eine Liste mit Single- und ListEntry-Elementen

		Die Struktur wird per Zufallsgenerator aufgebaut, wobei die Wahrscheinlichkeit
		fr das Erzeugen neuer ListEntry-Elemente mit jeder zustzlichen Hierarchie-
		Ebene sinkt:
			if (Random(10*Level) < 1) then <New List, Rekursion mit Level+1>
			 else <New Single Entry>
		Das Element der obersten Ebene ist eine Liste, entspricht dem Stammverzeichnis.

		Untersucht das Laufzeitverhalten von
		- Objektverwaltung (1 Mio Objekte)
		- Stringmanipulationen
		- Listen bzw. Arrays (24 Millionen Suchvorgnge)
		- Random-Generator
		- Stackverwaltung
	*/

namespace ListList_OOP_CSharp_2000
{
	/// <summary>
	/// Zusammenfassung fr Form1.
	/// </summary>
	public class LLForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button bCreateTree;
		private System.Windows.Forms.Button bBenchCreate;
		private System.Windows.Forms.ListBox listBox1;
		/// <summary>
		/// Erforderliche Designervariable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public LLForm()
		{
			//
			// Erforderlich fr die Windows Form-Designeruntersttzung
			//
			InitializeComponent();

			//
			// TODO: Fgen Sie den Konstruktorcode nach dem Aufruf von InitializeComponent hinzu
			//
		}

		/// <summary>
		/// Die verwendeten Ressourcen bereinigen.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Vom Windows Form-Designer generierter Code
		/// <summary>
		/// Erforderliche Methode fr die Designeruntersttzung. 
		/// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
		/// </summary>
		private void InitializeComponent()
		{
			this.bCreateTree = new System.Windows.Forms.Button();
			this.bBenchCreate = new System.Windows.Forms.Button();
			this.listBox1 = new System.Windows.Forms.ListBox();
			this.SuspendLayout();
			// 
			// bCreateTree
			// 
			this.bCreateTree.Location = new System.Drawing.Point(24, 16);
			this.bCreateTree.Name = "bCreateTree";
			this.bCreateTree.Size = new System.Drawing.Size(184, 23);
			this.bCreateTree.TabIndex = 0;
			this.bCreateTree.Text = "bCreateTree (100 Entries)";
			this.bCreateTree.Click += new System.EventHandler(this.bCreateTree_Click);
			// 
			// bBenchCreate
			// 
			this.bBenchCreate.Location = new System.Drawing.Point(24, 48);
			this.bBenchCreate.Name = "bBenchCreate";
			this.bBenchCreate.Size = new System.Drawing.Size(184, 23);
			this.bBenchCreate.TabIndex = 2;
			this.bBenchCreate.Text = "bBenchCreate (1 Mio Entries)";
			this.bBenchCreate.Click += new System.EventHandler(this.bBenchCreate_Click);
			// 
			// listBox1
			// 
			this.listBox1.Location = new System.Drawing.Point(8, 88);
			this.listBox1.Name = "listBox1";
			this.listBox1.Size = new System.Drawing.Size(216, 303);
			this.listBox1.TabIndex = 3;
			// 
			// LLForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(232, 405);
			this.Controls.Add(this.listBox1);
			this.Controls.Add(this.bBenchCreate);
			this.Controls.Add(this.bCreateTree);
			this.Name = "LLForm";
			this.Text = "C#: ListList_OOP 2003";
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Der Haupteinstiegspunkt fr die Anwendung.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new LLForm());
		}

		ListEntry RootDir = null; // "Stammverzeichnis"
		int EntryCount; // Runterzhler frs Anlegen der Struktur
		Random Rand = new Random();

		private void BuildListList(SingleEntry List, int Level)
		{ // Listenaufbau (rekursiv)
			int LocalCount = Rand.Next(25)+1;
			int NameLength;
			string NewName;
		
			// maximal 25 Eintrge pro Liste - nur das Stammverzeichnis
			// kann mehr haben
			for (int x = 1; x <= LocalCount; x++)
			{
				EntryCount--;
				// zuflliger Name mit 1-8 Zeichen
				NameLength = Rand.Next(8)+1;
				NewName = "";
				for (int y = 1; y <= NameLength; y++)
					NewName = NewName + (char)((int)'a' + Rand.Next(26));
				// Einzelner Eintrag oder neue Liste? Die Wahrscheinlichkeit
				// fr neue Listen (und weitere Rekursion) sinkt mit zunehmender
				// Verschachelungstiefe
				if (Rand.Next(10*Level) < 1) 
          BuildListList(List.AddNode(NewName), Level+1);
				else List.AddEntry(NewName);

				if (EntryCount <= 0)
					break;
			}
		}

    public void ClearList()
    {
      RootDir = new ListEntry("C:");
			GC.Collect();  // sync
    }

		private void BuildBaseList(int ECount)
		{ // Legt die Elementenzahl fest und erzeugt das Stammverzeichnis
		
      // neu besetzen = die gesamte Struktur abrumen

			EntryCount = ECount;
			while (EntryCount > 0)
				BuildListList(RootDir,1);
		}

		private void bCreateTree_Click(object sender, System.EventArgs e)
		{ 
			// Demo-Liste mit 100 Elementen, Anzeige
			listBox1.Items.Clear();
      ClearList();
			BuildBaseList(100); 
			PrintListList(RootDir, 1);
		}

		private void ShowEntry(string S)
		{  // Anzeige in der Listbox, auch fr Suchergebnisse
			listBox1.Items.Add(S);
		}

		private void PrintListList(SingleEntry List, int Level)
		{ // Ausgabe der Demo-Liste (100 Elemente)
			string Lead = "";
			SingleEntry CurEntry;

			for (int x = 1; x < Level; x++)
				Lead = Lead + "  ";

			// EntryName+' (LIST) fr Verzeichnisse
			ShowEntry(Lead+List.GetDisplayName());
			// Dateieintrge und Verzeichnisse, ungeordnet
			CurEntry = List.FirstEntry();
			while (CurEntry != null)
			{
				PrintListList(CurEntry, Level+1);
				CurEntry = List.NextEntry(CurEntry);
			}
		}

		// Liefert den vollstndigen Pfad des ersten Vorkommens von SubStr 
		// zurck, falls vorhanden. Aufruf mit RootDir
		private string FindListEntry(SingleEntry List, string SubStr)
		{	SingleEntry E = List.FindEntry(SubStr);

			if (E != null) return E.FullName();
			 else return "";
		}

		[System.Runtime.InteropServices.DllImport("winmm.dll")]
		private static extern int timeGetTime();

		// 1 Million Objekte, 24 Millionen Suchvorgnge
		private void bBenchCreate_Click(object sender, System.EventArgs e)
		{
      TimeSpan fullBench = new TimeSpan(0);
      TimeSpan constructionTime = new TimeSpan(0);
      TimeSpan destructionTime = new TimeSpan(0);      
      TimeSpan findTime = new TimeSpan(0);      
      DateTime start;
      DateTime meanTime; 

      ClearList();
      listBox1.Items.Clear();
			start = DateTime.Now;

			for (int x = 1; x <= 10; x++)
			{
        meanTime = DateTime.Now; 
        BuildBaseList(100000);
        constructionTime += (DateTime.Now - meanTime);
        meanTime = DateTime.Now; 
        ShowEntry("Search a: " + FindListEntry(RootDir, "a"));
				ShowEntry("Search ax: " + FindListEntry(RootDir, "ax"));
			  ShowEntry("Search axv: " + FindListEntry(RootDir, "axv"));
				ShowEntry("Search axve: " + FindListEntry(RootDir, "axve"));
				for (int y = 1; y <= 20; y++)
					FindListEntry(RootDir,"X"); // gibts nicht
        findTime += (DateTime.Now - meanTime);
        listBox1.Update();  // Lebenszeichen
				meanTime = DateTime.Now;
				ClearList();
				destructionTime += (DateTime.Now - meanTime);
      }

      MessageBox.Show("Time:\t\t"+(DateTime.Now-start +
        "\nfor Construction:\t"+ constructionTime +
        "\nfor Destruction:\t"+ destructionTime +
        "\nfor Find:\t\t"+ findTime), this.Text);
    }
	}

	public class SingleEntry // einzelnes Element
	{
		private string FEntryName;
		protected SingleEntry ParentList; // backtracking

		public SingleEntry(string EName) { FEntryName = EName; }
		public SingleEntry(string EName, SingleEntry Parent) : this(EName)
		{
			ParentList = Parent;
		}

		public string EntryName { get { return FEntryName; } }
		public virtual string GetDisplayName() { return EntryName; }

		public string FullName()
		{
			if (ParentList != null) return ParentList.FullName()+'\\'+ EntryName;
			else return EntryName;
		}

		public virtual SingleEntry FindEntry(string PartialName)
		{
			//if (EntryName.IndexOf(PartialName) != -1) return this; // 8.7
			//if (EntryName.StartsWith(PartialName)) return this; 7.3
			if (EntryName == PartialName) return this; // 5.1
			  else return null;
		}

		public virtual SingleEntry AddEntry(string EName)
		{ 
			throw new Exception("SingleEntry.AddEntry: not implemented");
		}

		public virtual SingleEntry AddNode(string NName)
		{ 
			throw new Exception("SingleEntry.AddNode: not implemented");
		}

		public virtual SingleEntry FirstEntry() { return null; }
		public virtual SingleEntry NextEntry(SingleEntry CurEntry) { return null; }
}

	public class ListEntry : SingleEntry // Verzeichnis
	{
		private ArrayList EntryList = null;  // SingleEntry und ListEntry gemischt

		public ListEntry(string EName) : base(EName)
		{
			EntryList = new ArrayList();
		}

		public ListEntry(string EName, SingleEntry Parent) : this(EName)
		{
			ParentList = Parent;
		}

		public override string GetDisplayName()
		{ 
			return EntryName + " (LIST)"; 
		}

		public override SingleEntry FindEntry(string PartialName)
		{
			SingleEntry Result = base.FindEntry(PartialName);

			if (Result == null)
				foreach (SingleEntry E in EntryList)
				{
					Result = E.FindEntry(PartialName);
					if (Result != null) 
						break;
				}
			return Result;
		}

		public override SingleEntry AddEntry(string EName)
		{
			SingleEntry Result = new SingleEntry(EName, this);
			EntryList.Add(Result);
			return Result;
		}

		public override SingleEntry AddNode(string NName)
		{
			ListEntry Result = new ListEntry(NName, this);
			EntryList.Add(Result);
			return Result;
		}
		public override SingleEntry FirstEntry()
		{
			if (EntryList.Count == 0) return null;
			else return (SingleEntry)EntryList[0];
		}

		public override SingleEntry NextEntry(SingleEntry CurEntry)
		{
				int x = EntryList.IndexOf(CurEntry);

			if (x != -1 && x+1 < EntryList.Count) return (SingleEntry)EntryList[x+1];
			else return null;
		}
	}

}
